/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.SearchGuardVersion;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.truststore.rest.TransportTruststoreUpdatedAction;
import com.floragunn.signals.truststore.service.TruststoreCrudService;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;

public class CreateOrReplaceTruststoreAction
extends Action<CreateOrReplaceTruststoreRequest, StandardResponse> {
    private static final Logger log = LogManager.getLogger(CreateOrReplaceTruststoreAction.class);
    public static final String NAME = "cluster:admin:searchguard:signals:truststores/createorreplace";
    public static final CreateOrReplaceTruststoreAction INSTANCE = new CreateOrReplaceTruststoreAction();
    public static final RestApi REST_API = new RestApi().responseHeaders((Map)SearchGuardVersion.header()).handlesPut("/_signals/truststores/{id}").with((Action)INSTANCE, (params, body) -> new CreateOrReplaceTruststoreRequest((String)params.get("id"), body)).name("PUT /_signals/truststores/{id}");

    public CreateOrReplaceTruststoreAction() {
        super(NAME, CreateOrReplaceTruststoreRequest::new, StandardResponse::new);
    }

    public static class CreateOrReplaceTruststoreRequest
    extends Action.Request {
        private static final String ENCAPSULATION_BOUNDARY_END = "-----END CERTIFICATE-----";
        public static final String FIELD_NAME = "name";
        public static final String FIELD_PEM = "pem";
        public static final String FIELD_ID = "id";
        private final String id;
        private final String name;
        private final String pem;

        public CreateOrReplaceTruststoreRequest(Action.UnparsedMessage message) throws ConfigValidationException {
            DocNode docNode = message.requiredDocNode();
            this.id = docNode.getAsString(FIELD_ID);
            this.name = docNode.getAsString(FIELD_NAME);
            this.pem = docNode.getAsString(FIELD_PEM);
        }

        public CreateOrReplaceTruststoreRequest(String id, UnparsedDocument<?> message) throws DocumentParseException {
            DocNode docNode = message.parseAsDocNode();
            this.id = id;
            this.name = docNode.getAsString(FIELD_NAME);
            this.pem = docNode.getAsString(FIELD_PEM);
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)FIELD_ID, (Object)this.id, (Object)FIELD_NAME, (Object)this.name, (Object)FIELD_PEM, (Object)this.pem);
        }

        public List<String> getCertificates() {
            return this.splitCertificatesByEncapsulationBoundaries();
        }

        private List<String> splitCertificatesByEncapsulationBoundaries() {
            int splitIndex;
            ArrayList<String> splitCertificates = new ArrayList<String>();
            String certificates = this.pem;
            while ((splitIndex = certificates.indexOf(ENCAPSULATION_BOUNDARY_END)) != -1) {
                String currentCertificate = certificates.substring(0, splitIndex += ENCAPSULATION_BOUNDARY_END.length());
                certificates = certificates.substring(splitIndex);
                splitCertificates.add(currentCertificate.trim());
            }
            return splitCertificates;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPem() {
            return this.pem;
        }
    }

    public static class UploadTruststoreHandler
    extends Action.Handler<CreateOrReplaceTruststoreRequest, StandardResponse> {
        private final TruststoreCrudService truststoreCrudService;
        private final NodeClient client;

        @Inject
        public UploadTruststoreHandler(Action.HandlerDependencies handlerDependencies, NodeClient client) {
            super((Action)INSTANCE, handlerDependencies);
            PrivilegedConfigClient privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
            TruststoreRepository truststoreRepository = new TruststoreRepository(privilegedConfigClient);
            this.client = client;
            this.truststoreCrudService = new TruststoreCrudService(truststoreRepository);
        }

        protected CompletableFuture<StandardResponse> doExecute(CreateOrReplaceTruststoreRequest request) {
            return this.supplyAsync(() -> {
                try {
                    StandardResponse response = this.truststoreCrudService.createOrReplace(request);
                    log.debug("Truststore with id '{}' stored in index.", (Object)request.getId());
                    TransportTruststoreUpdatedAction.TruststoreUpdatedActionType.send((Client)this.client, request.getId(), "create-or-update").actionGet();
                    log.debug("Notification related to truststore '{}' update send.", (Object)request.getId());
                    return response;
                }
                catch (ConfigValidationException e) {
                    log.error("Cannot create or replace truststore", (Throwable)e);
                    return new StandardResponse(400).error("Cannot create or replace truststore. " + e.getMessage());
                }
            });
        }
    }
}

